<?php
function mykassa_config() 
{
	$configarray = array(
		'FriendlyName' => array(
			'Type' => 'System',
			'Value' => 'Mykassa'
		),
		'mykassa_url' => array(
			'FriendlyName' => 'URL мерчанта (по умолчанию, http://www.mykassa.org/api/merchant.php)',
			'Type' => 'text',
			'Size' => '100',
			'Default' => 'http://www.mykassa.org/api/merchant.php'
		),
		'mykassa_shop' => array(
		  'FriendlyName' => 'Идентификатор магазина',
		  'Type' => 'text',
		  'Size' => '50'
		),
		'mykassa_secret_key' => array(
		  'FriendlyName' => 'Секретный ключ',
		  'Type' => 'text',
		  'Size' => '100'
		),
		'mykassa_logfile' => array(
		  'FriendlyName' => 'Путь до файла для журнализации оплат (например, /mykassa_orders.log)',
		  'Type' => 'text',
		  'Size' => '100'
		),
		'mykassa_ipfilter' => array(
		  'FriendlyName' => 'IP - фильтр обработчика',
		  'Type' => 'text',
		  'Size' => '100'
		),
		'mykassa_email_error' => array(
		  'FriendlyName' => 'Email для ошибок оплаты',
		  'Type' => 'text',
		  'Size' => '100'
		)
	);

	return $configarray;
}

function mykassa_link($params) 
{
	global $_LANG;

	$m_url = $params['mykassaurl'];
	$m_shop = $params['mykassa_shop'];
	$m_orderid = $params['invoiceid'];
	$m_amount = number_format($params['amount'], 2, '.', '');
	$m_curr = $params['currency'];
	$m_desc = base64_encode($params['description']);
	$m_key = $params['mykassa_secret_key'];
	$m_lang = $params['clientdetails']['language'] == 'russian' ? 'ru' : 'en';
	
	$arHash = array(
		$m_shop,
		$m_orderid,
		$m_amount,
		$m_curr,
		$m_desc,
		$m_key
	);
	$sign = strtoupper(hash('sha256', implode(':', $arHash)));

	$code = '
		<form id = "form_payment_mykassa" method="GET" action="' . $m_url . '">
			<input type="hidden" name="m_shop" value="' . $m_shop . '">
			<input type="hidden" name="m_orderid" value="' . $m_orderid . '">
			<input type="hidden" name="m_amount" value="' . $m_amount . '">
			<input type="hidden" name="m_curr" value="' . $m_curr . '">
			<input type="hidden" name="m_desc" value="' . $m_desc . '">
			<input type="hidden" name="m_sign" value="' . $sign . '">
			<input type="hidden" name="lang" value="' . $m_lang . '">
			<input type="submit" name="m_process" value="' . $_LANG['invoicespaynow'] . '" />
		</form>
		';

	return $code;
}